package edu.unl.consystlab.sudoku;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;


class FileMenu extends JMenu implements ActionListener
{
	private JMenuItem save,load,solve,stop,clear,fixate,quit;
	private Game game;
	
	public FileMenu(Game game)
	{
		super("File");
		this.game = game;
		
		this.add(save = new JMenuItem("Save"));
		save.addActionListener(this);
		
		this.add(load = new JMenuItem("Load"));
		load.addActionListener(this);
		
		this.add(solve = new JMenuItem("Solve"));
		solve.addActionListener(this);
		
		this.add(stop = new JMenuItem("Stop"));
		stop.addActionListener(this);
		
		this.add(clear = new JMenuItem("Clear"));
		clear.addActionListener(this);
		
		this.add(fixate = new JMenuItem("Fixate"));
		fixate.addActionListener(this);
		
		this.add(quit = new JMenuItem("Quit"));
		quit.addActionListener(this);		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent event)
	{
		Object o = event.getSource();
		if(o!=null && o instanceof JMenuItem)
		{
			JMenuItem item =(JMenuItem)o;
			if(o==load)
			{
				game.load();
			}
			if(o==save)
			{
				game.save();
			}
			if(o==solve)
			{
				game.solve();
			}
			if(o==stop)
			{
				game.stop();
			}
			if(o==clear)
			{
				game.clear();
			}
			if(o==fixate)
			{
				game.lockToggle();
			}
			if(o==quit)
			{
				game.quit();
			}
		}
		
	}
}

